<?php

//Prevent direct access to this file
if ( ! defined( 'WPINC' ) ) {
    die();
}

/**
 * Enqueue the Gutenberg block assets for the backend.
 *
 * 'wp-blocks': includes block type registration and related functions.
 * 'wp-element': includes the WordPress Element abstraction for describing the structure of your blocks.
 */
function dalt_editor_assets() {

    $shared = dalt_Shared::get_instance();

    //Styles -----------------------------------------------------------------------------------------------------------

    //Block
    wp_enqueue_style(
        'dalt-editor-css',
        plugins_url( 'dist/editor.css', dirname( __FILE__ ) ),
        array( 'wp-edit-blocks' )//Dependency to include the CSS after it.
    );

    //Scripts ----------------------------------------------------------------------------------------------------------

    //Block
    wp_enqueue_script(
        'dalt-editor-js', // Handle.
        plugins_url( '/dist/blocks.build.js', dirname( __FILE__ ) ), //We register the block here.
        array( 'wp-blocks', 'wp-element' ), // Dependencies.
        false,
        true //Enqueue the script in the footer.
    );

    /*
     * Add the translations associated with this script in the JED/json format.
     *
     * Reference: https://make.wordpress.org/core/2018/11/09/new-javascript-i18n-support-in-wordpress/
     *
     * Argument 1: Handler
     * Argument 2: Domain
     * Argument 3: Location where the JED/json file is located.
     *
     * Note that:
     *
     * - The JED/json file should be named [domain]-[locale]-[handle].json to be actually detected by WordPress.
     * - The JED/json file is generated with https://github.com/mikeedwards/po2json from the .po file
     */
	wp_set_script_translations( 'dalt-editor-js', 'dalt', $shared->get('dir') . 'blocks/lang' );

}
add_action( 'enqueue_block_editor_assets', 'dalt_editor_assets' );

/**
 * Enqueue the Gutenberg block assets for both frontend and backend.
 */
function dalt_style_assets() {

    //Not used with this block.
    return;

    //Styles -----------------------------------------------------------------------------------------------------------
    wp_enqueue_style(
        'dalt-style-css',
        plugins_url( 'dist/style.css', dirname( __FILE__ ) ),
        array( 'wp-blocks' )//Dependency to include the CSS after it
    );

}
add_action( 'enqueue_block_assets', 'dalt_style_assets' );

/**
 * Dynamic Block Server Component
 *
 * For more info:
 *
 * https://wordpress.org/gutenberg/handbook/blocks/creating-dynamic-blocks/
 */
function dalt_select_table_render($attributes) {

    if(isset($attributes['tableId'])){
        $public = dalt_Public::get_instance();
        return $public->display_league_table(array('id' => $attributes['tableId']));
    }

}
register_block_type( 'dalt/select-table', array(
    'render_callback' => 'dalt_select_table_render',
) );